#
# * PROPOSAL
# *
# * Reflect Orbital
# *
# * Mirrors in space riding the day/night terminator,
# * extending daylight a little.
# *
# * Not including the 'helix orbit' that Reflect is working on.
# *
# $Id: reflect.tcl 221 2024-08-27 03:22:41Z lloydwood $

# * "they’ll be deploying satellites into what they call
# * a sun-synchronous orbit (SSO) at an altitude of 600 km above
# * the Earth. Deploying a ring of 57 of these SSO mirrors would
# * allow Reflect Orbital to provide an additional 30 minutes of
# * sunshine to a solar farm anywhere on Earth."
# * -- Reflect Orbital Aims to Keep Sunlight Shining On Solar Farms
# * After The Sun Goes Down, Kyle Field, Cleantechnica, 12 June 2024.
# http://cleantechnica.com/2024/06/12/reflect-orbital-aims-to-keep-sunlight-shining-on-solar-farms-after-the-sun-goes-down/
# *
# * For some other designs and pointers to the literature,
# * see:
# * O. Celik and C. McInnes, A constellation design for orbiting
# * solar reflectors to enhance terrestrial solar energy,
# * Acta Astronautica, vol. 217, April 2024, pp. 145-161.
# https://doi.org/10.1016/j.actaastro.2024.01.031
# *
set a [expr 600.0+$RADIUS_OF_EARTH]

# we calculate inclination from the formula given in Wikipedia.
# https://en.wikipedia.org/wiki/Sun-synchronous_orbit
# need to add .0 to force floating-point, even in sub-calculations.
set inc [expr  180.0 / $PI * acos (-pow(($a / 12352.0), (7.0/2) )) ]
puts stderr "\nSaVi: sun-synchronous orbit inclination is $inc degrees."

set e 0.0
set omega 0.0

# ascending over Equator at 6pm to match SaVi's equinox start.
set Omega [expr 18.00/24 * 360.0]

# * Zero-degree mask elevation shows limit of reflector visibility,
# * but sunlight will be reflected in directed spots within that -
# * and those directed ground-fixed spots will presumably be billed.

set coverage_angle 0.0

set SATS_PER_PLANE 57

# compute period of orbit
set T_per [expr 2 * $PI * pow($a,1.5) / sqrt($MU)]

satellites GV_BEGIN

# sun-synchronous, so turn on sunlight
upvar #0 sun_flag sun_flag
set sun_flag 1

for {set i 0} {$i < $SATS_PER_PLANE} {incr i} {
    set T [expr -$T_per / $SATS_PER_PLANE * $i ]
    satellites LOAD $a $e $inc $Omega $omega $T "Reflect ($i)"
}

satellites GV_END
