#
# * THEORETICAL CONSTELLATIONS
# *
# * TianQin three-satellite high orbital constellation
# *
# * Uses intersatellite links, which are not yet simulated here.
# *
# * This proposed three high-orbital satellites spaced 120 deg apart,
# * in a polar plane facing a distant star, for gravitational wave
# * detection.
# *
# * A test satellite was launched into LEO in December 2019.
# *
# * Juo Luo et al., TianQin: a space-borne gravitational wave detector,
# * Classical and Quantum Gravity, vol. 33, no. 3, Jamuary 2016.
#
# http://dx.doi.org/10.1088/0264-9381/33/3/035010
# https://arxiv.org/abs/1512.02076
# https://en.wikipedia.org/wiki/TianQin
#
# this script for SaVi by Lloyd Wood (lloydwood@users.sourceforge.net)
# http://savi.sf.net/
#
# $Id: tianqin.tcl 219 2024-03-22 07:49:49Z lloydwood $

set NUM_SATS 3

# set location of one satellite; the others will be spaced from it
# east is positive. Align with day/night terminator
set sat_longitude 180

# setup orbital elements - that really is 10,000 km. Polar, circular.
set a 100000.0
set e 0.0
set inc 90.0
set omega $sat_longitude
set Omega 0.0
set T_per [expr 2 * $PI * pow($a,1.5) / sqrt($MU)]

# for illustration purposes; large areas of visibility for connectivity
# to a few ground station locations.
set coverage_angle 5.0

satellites GV_BEGIN

# turn on sunlight
upvar #0 sun_flag sun_flag
set sun_flag 1

# Turning on starfield is appropriate.
upvar #0 stars_flag stars_flag
set stars_flag 1

for {set i 1} {$i <= $NUM_SATS} {incr i} {
   set T [expr $T_per * $i / $NUM_SATS ]
   satellites LOAD $a $e $inc $Omega $omega $T "TianQuin-SC$i"
}

satellites GV_END
